/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.util;

import java.util.ArrayList;

public class StringUtils {
    public static final String LOWERCASE = "abcdefghijklmnopqrstuvwxyz";
    public static final String UPPERCASE = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    public static final String NUMERIC = "0123456789";
    private static String[] STRING_ARRAY_TYPE = new String[0];
    private static ThreadLocal threadLocalStringBuffer = new ThreadLocal();

    public static String replace(String text, String str, String newStr) {
        if (text == null || str == null || newStr == null) {
            throw new IllegalArgumentException("StringUtils.replace(text, str, newStr): Null arguments not accepted");
        }
        if (!str.equals(newStr)) {
            int endIndex;
            StringBuffer sb = new StringBuffer(text.length());
            int startIndex = 0;
            while ((endIndex = text.indexOf(str, startIndex)) != -1) {
                sb.append(text.substring(startIndex, endIndex));
                sb.append(newStr);
                startIndex = endIndex + str.length();
            }
            sb.append(text.substring(startIndex));
            return sb.toString();
        }
        return text;
    }

    public static boolean isAlphabetic(String s) {
        return StringUtils.isValid(s, "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz");
    }

    public static boolean isAlphanumeric(String s) {
        return StringUtils.isValid(s, "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789");
    }

    public static boolean isNumeric(String s) {
        return StringUtils.isValid(s, NUMERIC);
    }

    public static boolean isValid(String s, String allowed) {
        boolean result = true;
        if (null != s) {
            int i = 0;
            while (i < s.length()) {
                if (-1 == allowed.indexOf(s.charAt(i))) {
                    result = false;
                    break;
                }
                ++i;
            }
        }
        return result;
    }

    public static String[] getMatches(String target, String[] domain) {
        ArrayList<String> hitList = new ArrayList<String>();
        int i = 0;
        while (i < domain.length) {
            if (domain[i].indexOf(target) != -1) {
                hitList.add(domain[i]);
            }
            ++i;
        }
        return hitList.toArray(STRING_ARRAY_TYPE);
    }

    public static StringBuffer getThreadLocalStringBuffer() {
        StringBuffer stringBuffer = (StringBuffer)threadLocalStringBuffer.get();
        if (stringBuffer == null) {
            stringBuffer = new StringBuffer();
            threadLocalStringBuffer.set(stringBuffer);
        } else {
            stringBuffer.setLength(0);
        }
        return stringBuffer;
    }
}

